/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Text;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Borland.Eco.Handles;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;
using Borland.Eco.UmlRt;
using Borland.Eco.Web;
using System.Globalization;
using Borland.Eco.Interfaces;

namespace Borland.Eco.Web
{
	///<summary>
	///Superclass of ECO web autoforms
	///</summary>
	public class AutoForm : System.Web.UI.Page
	{
		protected virtual Borland.Eco.Handles.EcoSpace EcoSpace
		{
			get { return null; }
		}

		protected virtual Control ParentControl
		{
			get { return null; }
		}

		protected virtual void RetrieveEcoSpace()
		{
		}


		protected virtual void DoneWithEcoSpace()
		{
		}


		private void Page_Load(object sender, System.EventArgs e)
		{
			//try {
				SetupPage();
			//}
			//catch (Exception ex)
			//{
			//	ShowMessage(ex.Message);
			//}
		}


		//Following situations apply:
		//  (0) List available classes
		//  (1) List objects of class with filter options
		//  (3) Display/Edit single object
		//  (4) Attach object to property from list of objects of class with filter options
		private void SetupPage()
		{
			RetrieveEcoSpace();
			rh.EcoSpace = EcoSpace;

			HandleSectionVisibility();

			string id = Request.Params[EcoQueryVariableNames.RootId];
			string ownerId = Request.Params[EcoQueryVariableNames.OwnerId];
			string ownerProperty = Request.Params[EcoQueryVariableNames.OwnerProperty];
			if (ownerId == null) {ownerId = string.Empty;}
			if (ownerProperty == null) {ownerProperty = string.Empty;}
			int propertyIndex = 0;

			if (ownerProperty != String.Empty)
			{
				try
				{
					propertyIndex = Int32.Parse(ownerProperty, CultureInfo.InvariantCulture);
				}
				catch {}
			}

			IObject obj = null;

			string className = Request.Params[EcoQueryVariableNames.Class];
			if (className == null)
				className = "";

			string create = Request.Params[EcoQueryVariableNames.Create];
			if (create != null && create != String.Empty)
			{
				if (!IsPostBack)
				{
					obj = ActionExecutor.Create(EcoSpace, className);
					id = WebUtils.IdForObject(EcoSpace, obj);
					StringBuilder url = new StringBuilder(string.Format(CultureInfo.InvariantCulture, "{0}?{1}={2}", Request.Url.LocalPath, EcoQueryVariableNames.RootId, id));
					if (ownerId != String.Empty && ownerProperty != String.Empty)
					{
						IObject owner = WebUtils.ObjectForId(EcoSpace, ownerId);
						url.Append(string.Format(CultureInfo.InvariantCulture, "&{0}={1}&{2}={3}", EcoQueryVariableNames.OwnerId, ownerId, EcoQueryVariableNames.OwnerProperty, ownerProperty));
						ActionExecutor.Link(EcoSpace, owner, propertyIndex, id);
					}

					Response.Redirect(url.ToString() );
					Response.Flush();
					Response.End();
					return;
				}
			}

			if (obj == null)
				if ((id != null) && (id.Length > 0))
					obj = WebUtils.ObjectForId(EcoSpace, id);


			string deleteId = Request.Params[EcoQueryVariableNames.DeleteId];
			if (deleteId != null && deleteId != String.Empty)
				ActionExecutor.Delete(EcoSpace, deleteId);

			string unlinkId = Request.Params[EcoQueryVariableNames.UnlinkId];
			if (unlinkId != null && unlinkId != String.Empty)
				ActionExecutor.Unlink(EcoSpace, obj, propertyIndex, unlinkId);

			string linkId = Request.Params[EcoQueryVariableNames.LinkId];
			if (linkId != null && linkId != String.Empty)
				ActionExecutor.Link(EcoSpace, obj, propertyIndex, linkId);



			if (className == String.Empty && obj == null)
				BuildClassList(); //Build list of classes
			else if (className != String.Empty && obj == null)
				BuildObjectList(ownerId, propertyIndex, className); //Build list of objects for class
			else if (obj != null)
			{
				rh.SetElement(obj);
				BuildControls(obj); //Build controls for object
			}
			if (!IsPostBack)
				DataBind();
								
		}

		private void Page_Unload(object sender, System.EventArgs e)
		{
			DoneWithEcoSpace();
		}

		public override void DataBind()
		{
			ElementHandle.EnsureAllBindingLists();
			base.DataBind();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// Required for Web Form Designer support
			//
			InitializeComponent();
			base.OnInit(e);
		}

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);
			this.Unload += new System.EventHandler(this.Page_Unload);
		}
		#endregion

		#region Utility methods
		protected void UpdateDatabase()
		{
			IPersistenceService persistenceService = EcoSpace.GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
			IDirtyListService dirtyListService = EcoSpace.GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
			persistenceService.UpdateDatabaseWithList(dirtyListService.AllDirtyObjects());
		}

		#endregion

		private ArrayList myPropertyBindings = new ArrayList();
		private ArrayList myMethodBindings = new ArrayList();
		private ReferenceHandle rh = new ReferenceHandle();
		private DataGrid mainGrid = null;

		private void BuildClassList()
		{
			Table table = ControlBuilder.MakeNewTable("MainTable", ParentControl); // do not localize
			table.CssClass = EcoCssClassNames.EcoAutoFormMainTable ;

			SetPageTitle(table, WebStringRes.sAllClassesTitle);

			TableRow tableRow = ControlBuilder.MakeNewTableRow("RowClassDropDown", table); // do not localize
			TableCell controlCell = ControlBuilder.MakeNewTableCell("CellControlClassDropDown", tableRow); // do not localize
			controlCell.CssClass = EcoCssClassNames.EcoAutoFormControlCell;
			controlCell.ColumnSpan = 2;

			Table classesTable = ControlBuilder.MakeNewTable("ClassListTable", controlCell); // do not localize
			table.CssClass = EcoCssClassNames.EcoAutoFormTable;

			if (!IsPostBack)
				foreach (IClass cls in EcoSpace.TypeSystem.AllClasses)
				{
					if (!WebUtils.IsLinkClass(EcoSpace, cls.Name))
					{
						TableRow classTableRow = ControlBuilder.MakeNewTableRow("RowClasses" + cls.Name, classesTable); // do not localize
						TableCell nameCell = ControlBuilder.MakeNewTableCell("CellLabelClass" + cls.Name, classTableRow); // do not localize
						TableCell showLinkCell = ControlBuilder.MakeNewTableCell("CellLinkShowClass" + cls.Name, classTableRow); // do not localize
						TableCell createLinkCell = ControlBuilder.MakeNewTableCell("CellLinkCreateClass" + cls.Name, classTableRow); // do not localize
						nameCell.CssClass = EcoCssClassNames.EcoAutoFormLabelCell;
						showLinkCell.CssClass = EcoCssClassNames.EcoAutoFormControlCell;
						createLinkCell.CssClass = EcoCssClassNames.EcoAutoFormControlCell;

						Label nameLabel = ControlBuilder.MakeNewLabel(nameCell, cls.Name);
						HyperLink showLink = ControlBuilder.MakeNewHyperLink("LinkShowClass" + cls.Name, showLinkCell);   // do not localize
						HyperLink createLink = ControlBuilder.MakeNewHyperLink(WebStringRes.sCreate, createLinkCell);

						showLink.Text = WebStringRes.sShow;
						createLink.Text = WebStringRes.sCreate;

						showLink.NavigateUrl = String.Format(CultureInfo.InvariantCulture, "{0}?{1}={2}", Request.Url.LocalPath, EcoQueryVariableNames.Class, cls.Name); // do not localize
						createLink.NavigateUrl = String.Format(CultureInfo.InvariantCulture, "{0}?{1}=1&{2}={3}", Request.Url.LocalPath, EcoQueryVariableNames.Create, EcoQueryVariableNames.Class, cls.Name); // do not localize
					}
				}
		}

		private void BuildObjectList(string ownerId, int ownerProperty, string className)
		{
			Table table = ControlBuilder.MakeNewTable("MainTable", ParentControl); // do not localize
			table.CssClass = EcoCssClassNames.EcoAutoFormMainTable;

			TableRow tableRow;
			TableCell controlCell;
			
			SetPageTitle ( table, WebStringRes.sAllObjectsOfClassTitle(className), true);

			WebUtils.AddHeaderRow(table, "Filter", WebStringRes.sFilterHeader, Request, Session); // do not localize

			IClassifier cls = EcoSpace.TypeSystem.GetClassifierByName(className);

			if (!(WebUtils.IsCollapsedSection(Session, "Filter"))) // do not localize
			{
				foreach (IFeature f in cls.Features)
				{
					if (f.FeatureType == FeatureType.Attribute)
					{
						CreateAttributeControl(f.Name,
							((IStructuralFeature)f).Type_.ObjectType,
							table,
							String.Empty,
							false,
							null);
					}
				}

				tableRow = ControlBuilder.MakeNewTableRow("RowFilterButton" + className, table); // do not localize
				controlCell = ControlBuilder.MakeNewTableCell("CellControlFilterButton" + className, tableRow); // do not localize
				controlCell.CssClass = EcoCssClassNames.EcoAutoFormControlCell;

				Button filterBtn = new Button();
				filterBtn.Text = WebStringRes.sFilterButtonText;
				filterBtn.Click += new EventHandler(FilterBtn_Click);
				controlCell.Controls.Add(filterBtn);
			}


			IObjectList list = null;

			if (!IsPostBack)
			{
				IOclService oclService = (IOclService) EcoSpace.GetEcoService(typeof(IOclService));
				list = (IObjectList) oclService.Evaluate(className + ".allInstances()"); // do not localize
			}

			WebUtils.AddHeaderRow(table, "Results", WebStringRes.sResultsHeader, Request, Session); // do not localize
			if (!(WebUtils.IsCollapsedSection(Session, "Results"))) // do not localize
			{
				tableRow = ControlBuilder.MakeNewTableRow("RowClass" + className, table); // do not localize
				controlCell = ControlBuilder.MakeNewTableCell("CellControlClass" + className, tableRow); // do not localize

				controlCell.CssClass = EcoCssClassNames.EcoAutoFormControlCell;
				controlCell.ColumnSpan = 2;

				string controlName = "MainGrid"; // do not localize

				bool selector = false;

				if (ownerId != null && ownerId.Length > 0)
					selector = true;

				mainGrid = MultiLinkBuilder.MakeNewDataGrid(
					controlName,
					controlCell,
					Request,
					Session,
					EcoSpace,
					list,
					ownerId,
					ownerProperty,
					selector,
					className,
					null );

			}

		}

		private void BuildControls(IObject obj)
		{
			Table table = ControlBuilder.MakeNewTable("MainTable", ParentControl); // do not localize
			table.CssClass = EcoCssClassNames.EcoAutoFormMainTable;

			string name = WebUtils.GetObjectDisplayName(EcoSpace, obj);
			//string className =WebUtils.GetObjectClassName(obj);
			HyperLink classLink =WebUtils.GetObjectClassLink(Request, EcoSpace, obj);

			//SetPageTitle ( table, WebStringRes.sSelectedObjectTitle(name, classLink), true );
			//SetPageTitle ( table, WebStringRes.sSelectedObjectTitle(name, className), true );
			SetPageTitle ( table, WebStringRes.sSelectedObjectAsString(name), true, classLink );

			IPropertyCollection properties = obj.Properties;

			TableRow tableRow = null;
			TableCell labelCell = null;
			TableCell controlCell = null;


			//Make three passes, taking attributes in the first pass,
			//  single links in the second and multi links in the third pass
			for (int pass = 0; pass < 3; pass++)
			{
				bool doPass = true;
				if (pass == 0) 
				{
					WebUtils.AddHeaderRow(table, "Attributes", WebStringRes.sPropertiesHeader, Request, Session); // do not localize
					if ((WebUtils.IsCollapsedSection(Session, "Attributes"))) // do not localize
						doPass = false;
				}
				else if (pass == 1) 
				{
					WebUtils.AddHeaderRow(table, "Roles", WebStringRes.sRolesHeader, Request, Session); // do not localize
					if ((WebUtils.IsCollapsedSection(Session, "Roles"))) // do not localize
						doPass = false;
				}
				else if (pass == 2) 
				{
					if ((WebUtils.IsCollapsedSection(Session, "Roles"))) // do not localize
						doPass = false;					
				}
				if (doPass)
				{
					for (int i = 0; i < properties.Count; i++)
					{
						IProperty prop = properties[i];
						IFeature sf = prop.StructuralFeature;
						EcoPropertyType propType = WebUtils.GetPropertyType(prop);
						string controlName = "ecoProp" + sf.Name; // do not localize

						bool componentReadOnly = prop.ReadOnly;

						// Handle multilinks
						if (propType == EcoPropertyType.MultiLink)
						{
							if (pass == 2)
	#region handle multilinks
							{
								tableRow = ControlBuilder.MakeNewTableRow("RowProp" + sf.Name, table); // do not localize
								labelCell = ControlBuilder.MakeNewTableCell("CellLabelProp" + sf.Name, tableRow); // do not localize
								controlCell = ControlBuilder.MakeNewTableCell("CellControlProp" + sf.Name, tableRow); // do not localize

								labelCell.CssClass = EcoCssClassNames.EcoAutoFormLabelCell;
								controlCell.CssClass = EcoCssClassNames.EcoAutoFormControlCell;

								ControlBuilder.MakeNewLabel(labelCell, sf);

								MultiLinkBuilder.MakeNewDataGrid(
									controlName,
									controlCell,
									Request,
									Session,
									EcoSpace,
									prop as IObjectList,
									WebUtils.IdForObject(EcoSpace, obj),
									i,
									false,
									String.Empty,
									prop );
							}
	#endregion
						}
						else
						// Handle attributes
						if (propType == EcoPropertyType.Attribute)
						{
							if (pass == 0)
	#region handle Attributes
							{
								CreateAttributeControl(sf.Name,
									((IStructuralFeature)sf).Type_.ObjectType,
									table,
									prop.AsObject,
									componentReadOnly,
									prop);
							}
	#endregion
						}
						else
						// handle single links
						if (propType == EcoPropertyType.SingleLink)
						{
							if (pass == 1)
	#region Handle singlelinks
							{
								tableRow = ControlBuilder.MakeNewTableRow("RowProp" + sf.Name, table); // do not localize
								labelCell = ControlBuilder.MakeNewTableCell("CellLabelProp" + sf.Name, tableRow); // do not localize
								controlCell = ControlBuilder.MakeNewTableCell("CellControlProp" + sf.Name, tableRow); // do not localize

								labelCell.CssClass = EcoCssClassNames.EcoAutoFormLabelCell;
								controlCell.CssClass = EcoCssClassNames.EcoAutoFormControlCell;

								ControlBuilder.MakeNewLabel(labelCell, sf);

								IObject linked = prop as IObject;
								if (linked.ObjectInstance != null)
								{
									HyperLink hl = ControlBuilder.MakeNewHyperLink(controlName, controlCell);
									hl.CssClass = EcoCssClassNames.EcoAutoFormObjectLink; // do not localize
									hl.NavigateUrl = String.Format(CultureInfo.InvariantCulture, "{0}?{1}={2}", Request.Url.LocalPath, EcoQueryVariableNames.RootId, WebUtils.IdForObject(EcoSpace, linked)); // do not localize
									hl.Text = WebUtils.GetObjectDisplayName(EcoSpace, linked);
									ControlBuilder.MakeNewSpace(controlCell);

									ControlBuilder.MakeNewBoldText(controlCell, "["); // do not localize
									HyperLink unlink = ControlBuilder.MakeNewHyperLink(controlName + "Unlink", controlCell); // do not localize
									unlink.CssClass = EcoCssClassNames.EcoAutoFormActionLink; // do not localize
									unlink.NavigateUrl = String.Format(CultureInfo.InvariantCulture, "{0}?{1}={2}&{3}={4}&{5}={6}", Request.Url.LocalPath, EcoQueryVariableNames.RootId, WebUtils.IdForObject(EcoSpace, obj), EcoQueryVariableNames.OwnerProperty, i.ToString(CultureInfo.InvariantCulture), EcoQueryVariableNames.UnlinkId, WebUtils.IdForObject(EcoSpace, linked)); // do not localize
									unlink.Text = WebStringRes.sUnlink;
									ControlBuilder.MakeNewBoldText(controlCell, "]"); // do not localize
									ControlBuilder.MakeNewSpace(controlCell);
								}

								ControlBuilder.MakeNewBoldText(controlCell, "[");
								HyperLink link = ControlBuilder.MakeNewHyperLink(controlName + "Link", controlCell); // do not localize
								link.CssClass = EcoCssClassNames.EcoAutoFormActionLink;

								link.NavigateUrl = String.Format(CultureInfo.InvariantCulture, "{0}?{1}={2}&{3}={4}&{5}={6}", Request.Url.LocalPath, EcoQueryVariableNames.OwnerId, WebUtils.IdForObject(EcoSpace, obj), EcoQueryVariableNames.OwnerProperty, i.ToString(CultureInfo.InvariantCulture), EcoQueryVariableNames.Class, prop.Owner.Properties[i].StructuralFeature.Type_.Name); // do not localize
								link.Text = WebStringRes.sLink;
								ControlBuilder.MakeNewBoldText(controlCell, "]");

							}
	#endregion
						}
					}

					if (pass == 0) 
					{
						tableRow = ControlBuilder.MakeNewTableRow("RowSubmitButton", table); // do not localize
						labelCell = ControlBuilder.MakeNewTableCell("CellLabelSubmitButton", tableRow); // do not localize
						controlCell = ControlBuilder.MakeNewTableCell("CellControlSubmitButton", tableRow); // do not localize

						labelCell.CssClass = EcoCssClassNames.EcoAutoFormLabelCell;
						controlCell.CssClass = EcoCssClassNames.EcoAutoFormControlCell;

						Button submitBtn = new Button();
						submitBtn.Text = WebStringRes.sSubmitButtonText;
						submitBtn.CssClass = EcoCssClassNames.EcoAutoFormButton;
						submitBtn.Click += new EventHandler(SubmitBtn_Click);
						controlCell.Controls.Add(submitBtn);

						Button deleteBtn = new Button();
						deleteBtn.Text = WebStringRes.sDeleteButtonText;
						deleteBtn.CssClass = EcoCssClassNames.EcoAutoFormButton;
						deleteBtn.Click += new EventHandler(DeleteBtn_Click);
						controlCell.Controls.Add(deleteBtn);
							
					}
				}
			}

			WebUtils.AddHeaderRow(table, "Operations", WebStringRes.sMethodsHeader, Request, Session); // do not localize

			if (!(WebUtils.IsCollapsedSection(Session, "Operations"))) // do not localize
				MethodCallBuilder.BuildControls(ParentControl, EcoSpace, rh, obj.UmlClass, table, myMethodBindings, this, Response, Request, Session);

			WebUtils.AddHeaderRow(table, "StateMachines", WebStringRes.sStateMachinesHeader, Request, Session); // do not localize

			if (!(WebUtils.IsCollapsedSection(Session, "StateMachines"))) // do not localize
				StatePageBuilder.BuildControls(ParentControl, EcoSpace, rh, table, myMethodBindings, this, "SM", Response, Request, Session);   // do not localize
		}

		private void Filter()
		{
			string filter = GetFilterAsOcl();
			string className = Request.Params[EcoQueryVariableNames.Class];  // do not localize
			IOclService oclService = (IOclService) EcoSpace.GetEcoService(typeof(IOclService));
			IObjectList list = (IObjectList) oclService.Evaluate(className + ".allInstances()" + filter); // do not localize

			ReferenceHandle rh = (ReferenceHandle) mainGrid.DataSource;
			rh.SetElement(list);

			mainGrid.DataBind();
		}

		private void Delete()
		{
			IObject obj = (IObject) rh.Element;
			string url = String.Format(CultureInfo.InvariantCulture, "{0}?{1}={2}", Request.Url.LocalPath, EcoQueryVariableNames.Class, obj.UmlClass.Name); // do not localize
			ActionExecutor.Delete(EcoSpace, obj);
			Response.Redirect(url);
			Response.Flush();
			Response.End();
		}

		private void SubmitBtn_Click(object source, EventArgs e)
		{
			try
			{
				foreach (EcoPropertyBinding b in myPropertyBindings)
					b.Apply();

				WebUtils.SaveSpace(EcoSpace);
				
				SetMethodButtonsEnabledStatus();
				RefreshPropertyControls();

			}
			catch (Exception ex)
			{
				ShowMessage(ex.ToString());
			}
		}

		private void FilterBtn_Click(object source, EventArgs e)
		{
			try
			{
				Filter();
			}
			catch (Exception ex)
			{
				ShowMessage(ex.ToString());
			}
		}

		private void DeleteBtn_Click(object source, EventArgs e)
		{
			try
			{
				Delete();
			}
			catch (Exception ex)
			{
				ShowMessage(ex.ToString());
			}
		}

		private void ClassList_SelectedIndexChanged(object source, EventArgs e)
		{
			try {
				ListBox ddl = source as ListBox;
				if (ddl.SelectedItem != null)
				{
					string url = String.Format(CultureInfo.InvariantCulture, "{0}?{1}={2}", Request.Url.LocalPath, EcoQueryVariableNames.Class, ddl.SelectedItem.Text); // do not localize
					Response.Redirect(url);
					Response.Flush();
					Response.End();
				}
			}
			catch (Exception ex)
			{
				ShowMessage(ex.ToString());
			}
		}

		private string GetFilterAsOcl()
		{
			StringBuilder filter = new StringBuilder();
			string part = string.Empty;
			foreach (EcoPropertyBinding b in myPropertyBindings)
			{
				part = b.AppendToFilter();
				if (part.Length > 0)
				{
					if (filter.Length > 0)
						filter.Append(" and "); // do not localize

					filter.Append(part);
				}
			}

			if (filter.Length > 0)
				return String.Format(CultureInfo.InvariantCulture, "->select(c|{0})", filter.ToString()); // do not localize

			return String.Empty;
		}

		public void RefreshPropertyControls()
		{
			foreach (EcoPropertyBinding b in myPropertyBindings)
				b.Refresh();
		}

		public void SetMethodButtonsEnabledStatus()
		{
			foreach (MethodButtonBinding b in myMethodBindings)
				b.SetButtonEnabledState();
		}

		private void CreateAttributeControl(string name, Type type, Table table, object value, bool componentReadOnly, IProperty prop)
		{
			bool allowNulls = false;
			string controlName = "ecoProp" + name; // do not localize
			TableRow tableRow = ControlBuilder.MakeNewTableRow("RowProp" + name, table); // do not localize
			TableCell labelCell = ControlBuilder.MakeNewTableCell("CellLabelProp" + name, tableRow); // do not localize
			TableCell controlCell = ControlBuilder.MakeNewTableCell("CellControlProp" + name, tableRow); // do not localize

			labelCell.CssClass = EcoCssClassNames.EcoAutoFormLabelCell;
			controlCell.CssClass = EcoCssClassNames.EcoAutoFormControlCell;

 			if (prop != null)
 			{
				IAttribute attrib = prop.StructuralFeature as IAttribute;
				if (attrib.EcoAttribute.IsStateAttribute)
					componentReadOnly = true;
				allowNulls = attrib.EcoAttribute.AllowNull; 				
 			}
				

			//Handle boolean values
			if (type == typeof(bool))
			{

				CheckBox cbxNull = null;
				CheckBox cbx = ControlBuilder.MakeNewCheckBox(controlName, controlCell, name);
				cbx.CssClass = EcoCssClassNames.EcoAutoFormControl;
				cbx.Enabled = !componentReadOnly;

				if (allowNulls)
				{
					cbxNull = ControlBuilder.MakeNewCheckBox(controlName + "NullState", controlCell, InterfacesStringRes.sPropertyNull(string.Empty));
					cbxNull.CssClass = EcoCssClassNames.EcoAutoFormControl;
					cbxNull.Checked = (value == null);
					cbxNull.Enabled = !componentReadOnly;					
				}

				if (value == null)
					value = false;

				cbx.Checked = (bool)value;

				if (prop != null)
					myPropertyBindings.Add(new CheckBoxAsBooleanBinding(cbx, cbxNull, prop));
				else
					myPropertyBindings.Add(new CheckBoxAsBooleanBinding(cbx, cbxNull, name));
			}
			else
			{
				if (value == null)
					value = "<NULL>";

				ControlBuilder.MakeNewLabel(labelCell, name);

				TextBox tbx = ControlBuilder.MakeNewTextBox(controlName, controlCell);
				tbx.CssClass = EcoCssClassNames.EcoAutoFormControl;
				tbx.Text = value.ToString() ;
				tbx.ReadOnly = componentReadOnly;
				if (prop != null)
				{
					string sLength = prop.StructuralFeature.TaggedValues.ValueForTag(EcoTaggedValues.Length.Tag);

					int length=0;
					try
					{
						length = Int32.Parse(sLength, CultureInfo.InvariantCulture);
					}
					catch
					{
					}

					if (length > 0)
						tbx.MaxLength = length;
				}

				if (prop != null)
					myPropertyBindings.Add(new TextBoxAsAttributeBinding(tbx, prop));
				else
					myPropertyBindings.Add(new TextBoxAsAttributeBinding(tbx, name));
			}

		}

		public void ShowMessage(string msg)
		{
			if (msg == null)
				throw new ArgumentNullException("msg");
			msg = msg.Replace("\r\n", ""); // do not localize
			HtmlGenericControl html = new HtmlGenericControl("script"); // do not localize
			html.InnerText = String.Format(CultureInfo.InvariantCulture, "alert('{0}');", msg.Replace("'", "\'").ToCharArray()); // do not localize

			this.ParentControl.Controls.Add(html);
		}

		private void SetPageTitle(Table table, string msg)
		{
			SetPageTitle(table, msg, false, null);
		}

		private void SetPageTitle(Table table, string msg, bool addAllClassesLink)
		{
			SetPageTitle(table, msg, addAllClassesLink, null);			
		}

		private void SetPageTitle(Table table, string msg, bool addAllClassesLink, HyperLink classLink)
		{
			TableRow tableRow = ControlBuilder.MakeNewTableRow("RowTitle", table); // do not localize
			TableCell controlCell = ControlBuilder.MakeNewTableCell("CellTitle", tableRow); // do not localize

			controlCell.CssClass = EcoCssClassNames.EcoAutoFormTitleCell; 
			//controlCell.Width = Unit.Percentage(100); 
			controlCell.Wrap = false;
			controlCell.VerticalAlign = VerticalAlign.Middle;
			if (classLink == null)
				ControlBuilder.MakeNewLabel(controlCell, msg);
			else
				controlCell.Controls.Add(classLink);
			
			if (addAllClassesLink) 
			{
				TableCell linkCell = ControlBuilder.MakeNewTableCell("CellTitleLink", tableRow); // do not localize
				linkCell.CssClass = EcoCssClassNames.EcoAutoFormTitleCell; 
				linkCell.HorizontalAlign = HorizontalAlign.Left;
				linkCell.Wrap = false;
				linkCell.Width = Unit.Percentage(100); 

				Table linkTable = ControlBuilder.MakeNewTable("TableTitleLink", linkCell); 
				TableRow linkRow = ControlBuilder.MakeNewTableRow("RowTitleLink", linkTable); // do not localize

				linkTable.CssClass = EcoCssClassNames.EcoAutoFormTable;

				if (classLink != null) 
				{					
					TableCell classLinkCell = ControlBuilder.MakeNewTableCell("CellTitleClassLink", linkRow); // do not localize
					classLinkCell.CssClass = EcoCssClassNames.EcoAutoFormTitleCell; 
					classLinkCell.HorizontalAlign = HorizontalAlign.Left;
					classLinkCell.Wrap = false;
					classLinkCell.Width = Unit.Percentage(100); 
					//classLinkCell.Controls.Add(classLink);
					ControlBuilder.MakeNewLabel(classLinkCell, msg);
				}


				TableCell allClassesLinkCell = ControlBuilder.MakeNewTableCell("CellTitleAllClassesLink", linkRow); // do not localize
				allClassesLinkCell.CssClass = EcoCssClassNames.EcoAutoFormTitleCell; 
				allClassesLinkCell.HorizontalAlign = HorizontalAlign.Right;
				allClassesLinkCell.Wrap = false;

				HyperLink link = ControlBuilder.MakeNewHyperLink("LinkAllClasses", allClassesLinkCell); // do not localize
				link.Text = WebStringRes.sAllClassesTitle;
				link.NavigateUrl = this.Request.Url.LocalPath;				

			}
			else
			{
				controlCell.ColumnSpan = 3;				
			}

		}

		private void HandleSectionVisibility()
		{
			if (Session["Started"] == null)
			{
				Session["CollapseFilter"] = true;
				Session["Started"] = true;
			}

			string collapse = Request.Params["Collapse"];
			if (collapse != null && collapse != "")
				if (Session["Collapse" + collapse] == null)
					Session["Collapse" + collapse] = true;

			string expand = Request.Params["Expand"];
			if (expand != null && expand != "")
				if (Session["Collapse" + expand] != null)
					Session.Remove("Collapse" + expand);
		}


	}
}
